# Setup Database MySQL untuk JiraFixx

## Prerequisites

1. **MySQL Server** - Pastikan MySQL sudah terinstall di sistem Anda
2. **Node.js** - Versi 14 atau lebih baru

## Langkah-langkah Setup

### 1. Install Dependencies

```bash
npm install
```

### 2. Setup Database MySQL

#### A. Buat Database dan User (Opsional)
```sql
-- Login ke MySQL sebagai root
mysql -u root -p

-- Buat database
CREATE DATABASE jira CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Buat user khusus (opsional)
CREATE USER 'jira_user'@'localhost' IDENTIFIED BY 'password_anda';
GRANT ALL PRIVILEGES ON jira.* TO 'jira_user'@'localhost';
FLUSH PRIVILEGES;
```

#### B. Import Schema (Opsional)
```bash
# Import schema dan data awal
mysql -u root -p jira < server/sql/init.sql
```

### 3. Konfigurasi Environment

Buat file `.env` di root project dengan isi:

```env
# Konfigurasi Database MySQL
DB_HOST=localhost
DB_USER=root
DB_PASSWORD=password_mysql_anda
DB_NAME=jira
DB_PORT=3306

# Konfigurasi Server
PORT=4000
```

**Atau** copy dari file contoh:
```bash
cp config.example.env .env
```

Lalu edit file `.env` sesuai konfigurasi MySQL Anda.

### 4. Jalankan Server

```bash
npm start
# atau
node server/server.js
```

## Struktur Database

### Tabel `country`
- `id` - Primary key (AUTO_INCREMENT)
- `name` - Nama lengkap negara
- `country_code` - Kode negara (UNIQUE) - akan dicari dalam summary issue

## API Endpoints

### Admin Countries
- `GET /api/admin/countries` - Ambil semua negara
- `POST /api/admin/countries` - Tambah negara baru
- `DELETE /api/admin/countries/:id` - Hapus negara

### Statistics
- `GET /api/stats/countries` - Statistik per negara
- `GET /api/stats/countries-status` - Statistik per negara dan status

## Troubleshooting

### Error: "ER_ACCESS_DENIED_ERROR"
- Pastikan username dan password MySQL benar
- Pastikan user memiliki privilege untuk database

### Error: "ER_BAD_DB_ERROR"
- Pastikan database `jira` sudah dibuat
- Cek nama database di file `.env`

### Error: "ECONNREFUSED"
- Pastikan MySQL server berjalan
- Cek port MySQL (default 3306)

### Error: "Table doesn't exist"
- Database akan otomatis membuat tabel saat pertama kali dijalankan
- Atau import manual: `mysql -u root -p jira < server/sql/init.sql`

## Data Awal

Sistem akan otomatis membuat tabel dan mengisi data awal negara-negara Asia Pasifik saat pertama kali dijalankan.

## Migration dari SQLite

Jika sebelumnya menggunakan SQLite, data akan tetap ada di file `countries.db` tetapi tidak akan digunakan lagi. Sistem sekarang menggunakan MySQL sebagai database utama.
