// server/database.js
const sqlite3 = require('sqlite3').verbose();
const path = require('path');

// Path ke database file (di direktori root project)
const dbPath = path.join(__dirname, '../countries.db');
const db = new sqlite3.Database(dbPath);

// Inisialisasi tabel countries
db.serialize(() => {
    db.run(`CREATE TABLE IF NOT EXISTS countries (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        code TEXT UNIQUE NOT NULL,
        name TEXT NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )`);

    // Insert default countries (jika belum ada)
    const defaultCountries = [
        ['indonesia', 'Indonesia'],
        ['malaysia', 'Malaysia'],
        ['png', 'Papua New Guinea'],
        ['philippines', 'Philippines'],
        ['brunei', 'Brunei'],
        ['us-', 'United States'],
        ['singapore', 'Singapore'],
        ['timor-leste', 'Timor Leste']
    ];

    const stmt = db.prepare("INSERT OR IGNORE INTO countries (code, name) VALUES (?, ?)");
    defaultCountries.forEach(country => {
        stmt.run(country[0], country[1]);
    });
    stmt.finalize();
});

module.exports = db;